/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.server;

import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;

public final class Configuration
implements Serializable {
    private static final int JPROP_FILENET_WCMAPICONFIG = 0;
    private static final int JPROP_USER_HOME = 1;
    private static final int JPROP_USER_DIR = 2;
    private static final int JPROP_JAVA_HOME = 3;
    static final String m_className = "Configuration";
    protected static Logger logger = Logger.getLogger("filenet.vw.server");
    private String m_parentDir = null;
    private StringBuffer m_progress = new StringBuffer();
    private String m_desc = null;
    boolean bTracePropMap = false;
    protected static final Locale EMPTY_LOCALE = new Locale("", "", "");
    private static Configuration G_CONFIGURATION = null;
    private HashMap propMap = null;
    private static final String RS = "RemoteServer";
    private static final String REMOTESERVERURL = "RemoteServerUrl";
    private static final String CONFIG_FILE = "WcmApiConfig";
    private static final long serialVersionUID = -4846791583317622778L;
    private static final String ITEM_MAP = "itemMap";
    private static final String BASENAME = "basename";
    private static final String IBMAP = "ibmap";
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("ibmap", HashMap.class)};

    public String toString() {
        if (this.m_desc == null) {
            this.tracePropMap();
            this.m_desc = this.m_progress.toString();
        }
        return this.m_desc;
    }

    private synchronized void tracePropMap() {
        if (this.bTracePropMap) {
            return;
        }
        this.bTracePropMap = true;
        if (this.propMap == null) {
            this.m_progress.append("NULL PROPERTY MAP!!");
            return;
        }
        for (Object key : this.propMap.keySet()) {
            this.m_progress.append("[").append(key).append("=").append(this.propMap.get(key));
        }
    }

    private Configuration(InputStream configStream) throws VWException {
        String m_method = "ctor:InputStream";
        try {
            this.m_progress.append("CTOR1:");
            this.propMap = Configuration.resourceBundleToHashMap(new PropertyResourceBundle(configStream), true);
            if (logger.isFinest()) {
                logger.finest(m_className, "ctor:InputStream", this.toString());
            }
        }
        catch (Throwable ie) {
            logger.throwing(m_className, "ctor:InputStream", ie);
            throw new VWException(ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Configuration(String basename) throws VWException {
        String m_method = "ctor:" + basename;
        String fullName = basename + ".properties";
        this.m_progress.append("\n").append(m_method);
        InputStream pFile = this.lookInFixedListOfPlaces(fullName);
        try {
            ResourceBundle rb = null;
            if (pFile != null) {
                try {
                    rb = new PropertyResourceBundle(pFile);
                    this.m_progress.append("\n").append(m_method).append(": Found via directory search");
                }
                catch (IOException ie) {
                    throw new VWException(ie);
                }
            } else {
                this.m_parentDir = null;
                rb = this.findBundleOnClasspath(basename);
            }
            if (rb == null) {
                throw new VWException("vw.api.configuration.FailedToGetConfigurationFile", "Failed to get configuration file {0}", fullName);
            }
            this.propMap = Configuration.resourceBundleToHashMap(rb, true);
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, this.toString());
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (pFile != null) {
                    pFile.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (pFile != null) {
                pFile.close();
            }
        }
        catch (Exception e) {}
    }

    private ResourceBundle findBundleOnClasspath(String basename) {
        String m_method = "findBundleOnClasspath:" + basename;
        HashSet loaders = new HashSet();
        ResourceBundle rb = null;
        ClassLoader loader = null;
        loader = this.getClass().getClassLoader();
        rb = this.findViaClassLoader(basename, loaders, loader);
        if (rb != null) {
            return rb;
        }
        loader = null;
        try {
            loader = Configuration.getPrivilegedSystemClassLoader();
        }
        catch (SecurityException e) {
            // empty catch block
        }
        rb = this.findViaClassLoader(basename, loaders, loader);
        if (rb != null) {
            return rb;
        }
        loader = null;
        try {
            loader = Configuration.getPrivilegedThreadClassLoader();
        }
        catch (SecurityException e) {
            // empty catch block
        }
        rb = this.findViaClassLoader(basename, loaders, loader);
        if (rb != null) {
            return rb;
        }
        loader = null;
        try {
            TrivialSecurityManagerSubclass tsms = new TrivialSecurityManagerSubclass();
            Class[] classes = tsms.getClassContext();
            for (int ii = 0; ii < classes.length; ++ii) {
                Class cls = classes[ii];
                loader = null;
                try {
                    loader = Configuration.getPrivilegedClassLoader(cls);
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "look into privileged class loader");
                    }
                }
                catch (SecurityException e) {
                    // empty catch block
                }
                rb = this.findViaClassLoader(basename, loaders, loader);
                if (rb == null) continue;
                return rb;
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        return null;
    }

    private static final ClassLoader getPrivilegedSystemClassLoader() {
        Object o = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
        return (ClassLoader)o;
    }

    private static final ClassLoader getPrivilegedThreadClassLoader() {
        Object o = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        return (ClassLoader)o;
    }

    private static final ClassLoader getPrivilegedClassLoader(final Class cls) {
        Object o = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return cls.getClassLoader();
            }
        });
        return (ClassLoader)o;
    }

    protected static HashMap resourceBundleToHashMap(ResourceBundle p, boolean lowerCase) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        Enumeration<String> e = p.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            Object value = p.getObject(key);
            m.put(lowerCase ? key.toLowerCase() : key, value);
        }
        return m;
    }

    private ResourceBundle findViaClassLoader(String basename, Set loaders, ClassLoader loader) {
        if (loader != null && !loaders.contains(loader)) {
            loaders.add(loader);
            try {
                ResourceBundle rb = ResourceBundle.getBundle(basename, EMPTY_LOCALE, loader);
                this.m_progress.append("\n").append("findViaClassLoader=").append(loader);
                return rb;
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        return null;
    }

    private InputStream lookInFixedListOfPlaces(String fullName) {
        String m_method = "lookInFixedListOfPlaces:" + fullName;
        String fnProp = null;
        try {
            fnProp = Configuration.getPrivilegedJavaProperty(0, this.m_progress);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (fnProp != null && fnProp.length() > 0) {
            File fnPath = new File(fnProp);
            try {
                FileInputStream res = new FileInputStream(fnPath);
                this.m_parentDir = fnPath.getAbsolutePath();
                this.m_progress.append("\n").append(m_method).append(":1:").append(this.m_parentDir);
                return res;
            }
            catch (Exception e) {
                return null;
            }
        }
        InputStream is = null;
        is = this.findInAPropertiedDirectory(fullName, 1);
        if (is != null) {
            return is;
        }
        is = this.findInAPropertiedDirectory(fullName, 2);
        if (is != null) {
            return is;
        }
        is = this.findInAPropertiedDirectory(fullName, 3);
        if (is != null) {
            return is;
        }
        return null;
    }

    private InputStream findInAPropertiedDirectory(String fullName, int whichProp) {
        this.m_parentDir = null;
        String m_method = "findInAPropertiesDirectory";
        String directory = null;
        try {
            directory = Configuration.getPrivilegedJavaProperty(whichProp, this.m_progress);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (directory == null || directory.length() == 0) {
            return null;
        }
        if (logger.isFinest()) {
            logger.finest(m_className, "findInAPropertiesDirectory", directory);
        }
        File fullNameInThisDir = new File(directory, fullName);
        try {
            if (fullNameInThisDir.canRead()) {
                this.m_parentDir = fullNameInThisDir.getAbsolutePath();
                this.m_progress.append("\n").append("findInAPropertiesDirectory").append(" found in ").append(this.m_parentDir);
                if (logger.isFinest()) {
                    logger.finest(m_className, "findInAPropertiesDirectory", "Found in " + this.m_parentDir);
                }
                return new FileInputStream(fullNameInThisDir);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    private static final String getPrivilegedJavaProperty(int whichOne, StringBuffer buf) throws VWException {
        String propName = null;
        switch (whichOne) {
            case 0: {
                propName = "filenet.wcmapiconfig";
                break;
            }
            case 2: {
                propName = "user.dir";
                break;
            }
            case 1: {
                propName = "user.home";
                break;
            }
            case 3: {
                propName = "java.home";
                break;
            }
            default: {
                return null;
            }
        }
        final String fpropName = propName;
        Object o = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(fpropName);
            }
        });
        if (logger.isFinest()) {
            logger.finest(m_className, "getPrivilegedJavaProperty", propName + "=" + o);
            if (buf != null) {
                buf.append("\n").append(fpropName).append("=").append(o);
            }
        }
        return (String)o;
    }

    private String getItemValue(String item) {
        if (item == null) {
            return null;
        }
        String s = (String)this.propMap.get(item.toLowerCase());
        return s;
    }

    public static String NormalizeCEURI(String s) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("cemp:") || s.startsWith("CEMP:")) {
            return s.substring(5);
        }
        return s;
    }

    public static Configuration GetGLOBALConfiguration(InputStream m_bootstrapConfigStream, String configFile) throws VWException {
        if (G_CONFIGURATION == null) {
            G_CONFIGURATION = m_bootstrapConfigStream != null ? new Configuration(m_bootstrapConfigStream) : new Configuration(configFile == null ? CONFIG_FILE : configFile);
        }
        return G_CONFIGURATION;
    }

    public static String GetGlobalConfigurationPath(InputStream m_bootstrapConfigStream, String configFile) throws VWException {
        Configuration.GetGLOBALConfiguration(m_bootstrapConfigStream, configFile);
        return Configuration.G_CONFIGURATION.m_parentDir;
    }

    public static String GetCEURI(InputStream m_bootstrapConfigStream, String configFile) throws VWException {
        Configuration.GetGLOBALConfiguration(m_bootstrapConfigStream, configFile);
        return Configuration.NormalizeCEURI(G_CONFIGURATION.getItemValue(REMOTESERVERURL));
    }

    public static String GetProperty(InputStream m_bootstrapConfigStream, String configFile, String propertyName) throws VWException {
        Configuration.GetGLOBALConfiguration(m_bootstrapConfigStream, configFile);
        return G_CONFIGURATION.getItemValue(propertyName);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField pf = s.putFields();
        HashMap<String, HashMap> ibmap = new HashMap<String, HashMap>();
        ibmap.put(ITEM_MAP, this.propMap);
        pf.put(IBMAP, ibmap);
        s.writeFields();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField gf = s.readFields();
        HashMap ibmap = (HashMap)gf.get(IBMAP, null);
        this.propMap = new HashMap((HashMap)ibmap.get(ITEM_MAP));
    }

    public static void main(String[] args) {
        try {
            String s = Configuration.GetCEURI(null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final class TrivialSecurityManagerSubclass
    extends SecurityManager {
        private TrivialSecurityManagerSubclass() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

